<?php
require_once(__DIR__ . '/utility.php');

function cluster_setup_controller_network($argv) {
    global $DTASCFG_XML_FILE, $BACKEND;

    /* check number of arguments */
    if (count($argv) < 2) {
        echo "Usage: cluster_setup_controller_network CLUSTER_ID DHCP IP MASK GATEWAY DNS\n";
        exit(1);
    }
    
    $sc_id = $argv[0];
    $dhcp_enabled = $argv[1];

    if (!$dhcp_enabled) {
        if(count($argv) != 6) {
            echo "Usage: cluster_setup_controller_network CLUSTER_ID DHCP IP MASK GATEWAY DNS\n";
            exit(1);
	}
    }
	
    $ip = $dhcp_enabled ? "" : $argv[2];
    $mask = $dhcp_enabled ? "" : $argv[3];
    $gateway = $dhcp_enabled ? "" : $argv[4];
    $dns = $dhcp_enabled ? "" : $argv[5];
    
    if (($xml = simplexml_load_file($DTASCFG_XML_FILE)) == false) {
        printf("Failed to load %s\n", $DTASCFG_XML_FILE);
        exit(1);        
    }

    $esxi_ip = "";
    $esxi_username = "";
    $esxi_password = "";

    dtascfg_get_cluster_exsi_config($sc_id, $esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);
    
    // ToDo : Need to read setting from cluster?
    $sandbox_controller_prefix = chop($xml->sandbox_controller->prefix);
    $sandbox_controller_admin_username = chop($xml->sandbox_controller->admin_username);
    $sandbox_controller_admin_password = $xml->sandbox_controller->admin_password;    
    
    start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);
    
    $retry = 10;
    $controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);
    while (!isset($controller_vix_vmpath)) 
    {
        sleep(3);
        $controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);
        
        $retry -= 1;
        if ($retry == 0) {
            break;
        }
    }
	
    if (!isset($controller_vix_vmpath)) {
        echo 'cannot find controller vix vmpath';
        exit(1);
    }
	
    // Escape variables since then they will be used in command line
    $esxi_username = escapeshellarg($esxi_username);
    $esxi_password = escapeshellarg($esxi_password);
    $sandbox_controller_admin_username = escapeshellarg($sandbox_controller_admin_username);
    $sandbox_controller_admin_password = escapeshellarg($sandbox_controller_admin_password);
    
    exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/network_config.php /tmp/network_config.php 2>&1", $result_array, $return_value);	
    if ($return_value != 0) print_error($result_array, $return_value);
	
    exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" \"/tmp/network_config.php\" $dhcp_enabled \"$ip\" \"$mask\" \"$gateway\" \"$dns\" \"\\\"\\\\\\\"> /tmp/network-info\\\\\\\"\\\"\" 2>&1", $result_array, $return_value);    
    if ($return_value != 0) print_error($result_array, $return_value);
    
    exec("$BACKEND copy_file_from_vm_to_server_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /tmp/network-info " . dirname(__FILE__) . "/ctrl-network-info 2>&1", $result_array, $return_value);    
    if ($return_value != 0) print_error($result_array, $return_value);
    
    exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/rm /tmp/network-info 2>&1", $result_array, $return_value);
    if ($return_value != 0) print_error($result_array, $return_value); 
    
    unset($result_array);
    exec("/bin/cat " . dirname(__FILE__) . "/ctrl-network-info", $result_array, $return_value);
    if ($return_value != 0) print_error($result_array, $return_value);
    
    $results = explode(" ", $result_array[0]);
    $ip = array_key_exists(0, $results) ? $results[0] : "";
    $mask = array_key_exists(1, $results) ? $results[1] : "";
    $gateway = array_key_exists(2, $results) ? $results[2] : "";
    $dns = array_key_exists(3, $results) ? $results[3] : "";
    
    unlink(dirname(__FILE__) . "/ctrl-network-info");
    
    if ($ip == "" || $mask == "" || $gateway == "" || $dns == "") {
        echo "fail to query network configurations from sandbox controller";
        exit(1);
    }
    else {
	    echo "$ip $mask $gateway $dns";
    }
}

